/*
 * Decompiled with CFR 0.152.
 */
package io.scanbot.sdk.ui_v2.barcode.common;

import android.graphics.Rect;
import io.scanbot.sdk.barcode.entity.BarcodeItem;
import io.scanbot.sdk.barcode.entity.ResultPoint;
import io.scanbot.sdk.camera.FrameHandler;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeItemMapper;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeMappedData;
import io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeMappingResult;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.DebugProbesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CancellableContinuation;
import kotlinx.coroutines.CancellableContinuationImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a!\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0002\u001a\u00020\fH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\r\u001a\u0017\u0010\u000e\u001a\u00020\u000f*\b\u0012\u0004\u0012\u00020\u000f0\u0010H\u0002\u00a2\u0006\u0002\u0010\u0011\u001a\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u0003*\b\u0012\u0004\u0012\u00020\u00030\u00132\u0006\u0010\u0004\u001a\u00020\u0005\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"averagePointDistanceToFrameCenter", "", "item", "Lio/scanbot/sdk/barcode/entity/BarcodeItem;", "frame", "Lio/scanbot/sdk/camera/FrameHandler$Frame;", "getUniqueBarcodeUUID", "", "loadData", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeMappedData;", "delegate", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItemMapper;", "Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItem;", "(Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItemMapper;Lio/scanbot/sdk/ui_v2/barcode/configuration/BarcodeItem;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCenterOfPoints", "Lio/scanbot/sdk/barcode/entity/ResultPoint;", "", "([Lio/scanbot/sdk/barcode/entity/ResultPoint;)Lio/scanbot/sdk/barcode/entity/ResultPoint;", "getFocusedBarcode", "", "rtu-ui-v2-barcode-common_release"})
@SourceDebugExtension(value={"SMAP\nBaseBarcodeViewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BaseBarcodeViewModel.kt\nio/scanbot/sdk/ui_v2/barcode/common/BaseBarcodeViewModelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 CancellableContinuation.kt\nkotlinx/coroutines/CancellableContinuationKt\n*L\n1#1,347:1\n2333#2,14:348\n1#3:362\n314#4,11:363\n*S KotlinDebug\n*F\n+ 1 BaseBarcodeViewModel.kt\nio/scanbot/sdk/ui_v2/barcode/common/BaseBarcodeViewModelKt\n*L\n306#1:348,14\n336#1:363,11\n*E\n"})
public final class BaseBarcodeViewModelKt {
    @Nullable
    public static final BarcodeItem getFocusedBarcode(@NotNull List<BarcodeItem> $this$getFocusedBarcode, @NotNull FrameHandler.Frame frame) {
        Object v0;
        Intrinsics.checkNotNullParameter($this$getFocusedBarcode, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Iterable $this$minByOrNull$iv = $this$getFocusedBarcode;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                BarcodeItem item = (BarcodeItem)minElem$iv;
                boolean bl = false;
                float minValue$iv = BaseBarcodeViewModelKt.averagePointDistanceToFrameCenter(item, frame);
                do {
                    Object e$iv = iterator$iv.next();
                    BarcodeItem item2 = (BarcodeItem)e$iv;
                    $i$a$-minByOrNull-BaseBarcodeViewModelKt$getFocusedBarcode$1 = false;
                    float v$iv = BaseBarcodeViewModelKt.averagePointDistanceToFrameCenter(item2, frame);
                    if (Float.compare(minValue$iv, v$iv) <= 0) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    private static final ResultPoint getCenterOfPoints(ResultPoint[] $this$getCenterOfPoints) {
        float centroidX = 0.0f;
        float centroidY = 0.0f;
        int n = $this$getCenterOfPoints.length;
        for (int i = 0; i < n; ++i) {
            ResultPoint knot = $this$getCenterOfPoints[i];
            centroidX += knot.getX();
            centroidY += knot.getY();
        }
        return new ResultPoint(centroidX / (float)$this$getCenterOfPoints.length, centroidY / (float)$this$getCenterOfPoints.length);
    }

    /*
     * WARNING - void declaration
     */
    public static final float averagePointDistanceToFrameCenter(@NotNull BarcodeItem item, @NotNull FrameHandler.Frame frame) {
        ResultPoint resultPoint;
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        ResultPoint.Companion companion = ResultPoint.Companion;
        ResultPoint resultPoint2 = BaseBarcodeViewModelKt.getCenterOfPoints(item.getResultPoints());
        Rect rect = frame.getFinderRect();
        if (rect != null) {
            void it;
            Rect rect2 = rect;
            ResultPoint resultPoint3 = resultPoint2;
            ResultPoint.Companion companion2 = companion;
            boolean bl = false;
            ResultPoint resultPoint4 = new ResultPoint((float)it.width() / 2.0f, (float)it.height() / 2.0f);
            companion = companion2;
            resultPoint2 = resultPoint3;
            resultPoint = resultPoint4;
        } else {
            resultPoint = new ResultPoint((float)frame.getWidth() / 2.0f, (float)frame.getHeight() / 2.0f);
        }
        return companion.distance(resultPoint2, resultPoint);
    }

    @NotNull
    public static final String getUniqueBarcodeUUID(@NotNull BarcodeItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return item.getTextWithExtension() + '_' + item.getBarcodeFormat().name();
    }

    @Nullable
    public static final Object loadData(@NotNull BarcodeItemMapper delegate, @NotNull io.scanbot.sdk.ui_v2.barcode.configuration.BarcodeItem item, @NotNull Continuation<? super BarcodeMappedData> $completion) {
        boolean $i$f$suspendCancellableCoroutine = false;
        Continuation<? super BarcodeMappedData> uCont$iv = $completion;
        boolean bl = false;
        CancellableContinuationImpl cancellable$iv = new CancellableContinuationImpl(IntrinsicsKt.intercepted(uCont$iv), 1);
        cancellable$iv.initCancellability();
        CancellableContinuation routine = (CancellableContinuation)cancellable$iv;
        boolean bl2 = false;
        delegate.mapBarcodeItem(item, new BarcodeMappingResult((CancellableContinuation<? super BarcodeMappedData>)routine){
            final /* synthetic */ CancellableContinuation<BarcodeMappedData> $routine;
            {
                this.$routine = $routine;
            }

            public void onResult(@NotNull BarcodeMappedData data) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                ((Continuation)this.$routine).resumeWith(Result.constructor-impl((Object)data));
            }

            public void onError() {
                ((Continuation)this.$routine).resumeWith(Result.constructor-impl((Object)ResultKt.createFailure((Throwable)new IllegalStateException("Mapping failed"))));
            }
        });
        Object object = cancellable$iv.getResult();
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            DebugProbesKt.probeCoroutineSuspended($completion);
        }
        return object;
    }
}

